#define _Digole_Serial_I2C_   
#define Ver 34               // if the version of firmware on display is V3.3 and newer, use it
#define MONO                 // if the screen panel is monochrome
#include <DigoleSerial.h>
//--------I2C setup
#if defined(_Digole_Serial_I2C_)
#include <Wire.h>
DigoleSerialDisp mydisp(&Wire, '\x27'); // I2C: A4: SDA (data line), A5: SCL (clock line).
#endif

//-- Font Files --
#include "font_helvR08.h" // Font File (Allocation 200)
#include "font_ncenR10.h"  // Font File (Allocation 201)
#include "font_ncenR12.h"  // Font File (Allocation 202)
#include "font_timR18.h"  // Font File (Allocation 203)


void setup() {
  mydisp.begin(); //initiate serial port
  mydisp.disableCursor(); //disable cursor, enable cursore use: enableCursor();
  mydisp.clearScreen(); //CLear screen

  /*-----use user font----*/
  //if module equipt with flash chip, all splash screen and user fonts stored in the chip(2MB), otherwise, stored in the MCU(16KB)
#if (Ver<33)&&defined(FLASH_CHIP)
  mydisp.print("This module only can use user fonts in flash chip.\n\r");
  delay1();
  delay1();
#else
  //in V3.3, predefined user font number 200,201,202,203 will occupy 2nd,3rd,4th,fifth 65KB in flash chip
  test_User_Font_Standard();
#endif
}

void loop() {

}
void test_User_Font_Standard(void) {

  mydisp.cleanDrawWindow();
  mydisp.drawStr(0, 0, "Loading Custom Font");
  delay(1000); //This delay is very important, it will let the module clean the receiving buffer,then accept bulk data bellow

  //download a user font: (font length, font address, index ), one time download needed
  
  //mydisp.downloadUserFont(sizeof(timR18), timR18, 0);   // Installed in address 200
  //mydisp.downloadUserFont(sizeof(ncenR12), ncenR12, 1); // Installed in address 201
  //mydisp.downloadUserFont(sizeof(ncenR10), ncenR10, 2); // Installed in address 202
  //mydisp.downloadUserFont(sizeof(helvR08), helvR08, 3); // Installed in address 203
  
  delay(500);
  mydisp.clearScreen();
  
  //user #1 user font, there are 4 user fonts can be used:200 ~ 203
  mydisp.setFont(200);
  mydisp.drawStr(0, 0, "NightLase");  


  
  mydisp.setFont(0);

}
